package io.burkard.cdk.services.ssm.cfnResourceDataSync

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SyncSourceProperty {

  def apply(
    sourceType: String,
    sourceRegions: List[String],
    awsOrganizationsSource: Option[software.amazon.awscdk.services.ssm.CfnResourceDataSync.AwsOrganizationsSourceProperty] = None,
    includeFutureRegions: Option[Boolean] = None
  ): software.amazon.awscdk.services.ssm.CfnResourceDataSync.SyncSourceProperty =
    (new software.amazon.awscdk.services.ssm.CfnResourceDataSync.SyncSourceProperty.Builder)
      .sourceType(sourceType)
      .sourceRegions(sourceRegions.asJava)
      .awsOrganizationsSource(awsOrganizationsSource.orNull)
      .includeFutureRegions(includeFutureRegions.map(Boolean.box).orNull)
      .build()
}
