package io.burkard.cdk.services.s3.cfnBucket

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TransitionProperty {

  def apply(
    storageClass: String,
    transitionDate: Option[java.time.Instant] = None,
    transitionInDays: Option[Number] = None
  ): software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty =
    (new software.amazon.awscdk.services.s3.CfnBucket.TransitionProperty.Builder)
      .storageClass(storageClass)
      .transitionDate(transitionDate.orNull)
      .transitionInDays(transitionInDays.orNull)
      .build()
}
