package io.burkard.cdk.services.route53

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PrivateHostedZoneProps {

  def apply(
    vpc: software.amazon.awscdk.services.ec2.IVpc,
    comment: Option[String] = None,
    zoneName: Option[String] = None,
    queryLogsLogGroupArn: Option[String] = None
  ): software.amazon.awscdk.services.route53.PrivateHostedZoneProps =
    (new software.amazon.awscdk.services.route53.PrivateHostedZoneProps.Builder)
      .vpc(vpc)
      .comment(comment.orNull)
      .zoneName(zoneName.orNull)
      .queryLogsLogGroupArn(queryLogsLogGroupArn.orNull)
      .build()
}
