package io.burkard.cdk.services.resiliencehub

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResiliencyPolicyProps {

  def apply(
    tier: String,
    policyName: String,
    policy: Map[String, _],
    tags: Option[Map[String, String]] = None,
    dataLocationConstraint: Option[String] = None,
    policyDescription: Option[String] = None
  ): software.amazon.awscdk.services.resiliencehub.CfnResiliencyPolicyProps =
    (new software.amazon.awscdk.services.resiliencehub.CfnResiliencyPolicyProps.Builder)
      .tier(tier)
      .policyName(policyName)
      .policy(policy.asJava)
      .tags(tags.map(_.asJava).orNull)
      .dataLocationConstraint(dataLocationConstraint.orNull)
      .policyDescription(policyDescription.orNull)
      .build()
}
