package io.burkard.cdk.services.opsworks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVolumeProps {

  def apply(
    stackId: String,
    ec2VolumeId: String,
    name: Option[String] = None,
    mountPoint: Option[String] = None
  ): software.amazon.awscdk.services.opsworks.CfnVolumeProps =
    (new software.amazon.awscdk.services.opsworks.CfnVolumeProps.Builder)
      .stackId(stackId)
      .ec2VolumeId(ec2VolumeId)
      .name(name.orNull)
      .mountPoint(mountPoint.orNull)
      .build()
}
