package io.burkard.cdk.services.memorydb

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnUserProps {

  def apply(
    userName: String,
    accessString: String,
    authenticationMode: AnyRef,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.memorydb.CfnUserProps =
    (new software.amazon.awscdk.services.memorydb.CfnUserProps.Builder)
      .userName(userName)
      .accessString(accessString)
      .authenticationMode(authenticationMode)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
