package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLoadBalancerTlsCertificate {

  def apply(
    internalResourceId: String,
    certificateDomainName: String,
    certificateName: String,
    loadBalancerName: String,
    isAttached: Option[Boolean] = None,
    certificateAlternativeNames: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificate =
    software.amazon.awscdk.services.lightsail.CfnLoadBalancerTlsCertificate.Builder
      .create(stackCtx, internalResourceId)
      .certificateDomainName(certificateDomainName)
      .certificateName(certificateName)
      .loadBalancerName(loadBalancerName)
      .isAttached(isAttached.map(Boolean.box).orNull)
      .certificateAlternativeNames(certificateAlternativeNames.map(_.asJava).orNull)
      .build()
}
