package io.burkard.cdk.services.lex

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBotVersion {

  def apply(
    internalResourceId: String,
    botVersionLocaleSpecification: List[_],
    botId: String,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lex.CfnBotVersion =
    software.amazon.awscdk.services.lex.CfnBotVersion.Builder
      .create(stackCtx, internalResourceId)
      .botVersionLocaleSpecification(botVersionLocaleSpecification.asJava)
      .botId(botId)
      .description(description.orNull)
      .build()
}
