package io.burkard.cdk.services.kinesisvideo

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnStreamProps {

  def apply(
    deviceName: Option[String] = None,
    mediaType: Option[String] = None,
    name: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    dataRetentionInHours: Option[Number] = None,
    kmsKeyId: Option[String] = None
  ): software.amazon.awscdk.services.kinesisvideo.CfnStreamProps =
    (new software.amazon.awscdk.services.kinesisvideo.CfnStreamProps.Builder)
      .deviceName(deviceName.orNull)
      .mediaType(mediaType.orNull)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .dataRetentionInHours(dataRetentionInHours.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .build()
}
