package io.burkard.cdk.services.elasticache

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSubnetGroupProps {

  def apply(
    description: String,
    subnetIds: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    cacheSubnetGroupName: Option[String] = None
  ): software.amazon.awscdk.services.elasticache.CfnSubnetGroupProps =
    (new software.amazon.awscdk.services.elasticache.CfnSubnetGroupProps.Builder)
      .description(description)
      .subnetIds(subnetIds.asJava)
      .tags(tags.map(_.asJava).orNull)
      .cacheSubnetGroupName(cacheSubnetGroupName.orNull)
      .build()
}
