package io.burkard.cdk.services.eks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KubernetesManifestOptions {

  def apply(
    prune: Option[Boolean] = None,
    ingressAlb: Option[Boolean] = None,
    ingressAlbScheme: Option[software.amazon.awscdk.services.eks.AlbScheme] = None,
    skipValidation: Option[Boolean] = None
  ): software.amazon.awscdk.services.eks.KubernetesManifestOptions =
    (new software.amazon.awscdk.services.eks.KubernetesManifestOptions.Builder)
      .prune(prune.map(Boolean.box).orNull)
      .ingressAlb(ingressAlb.map(Boolean.box).orNull)
      .ingressAlbScheme(ingressAlbScheme.orNull)
      .skipValidation(skipValidation.map(Boolean.box).orNull)
      .build()
}
