package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceOptionsBase {

  def apply(
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None,
    iops: Option[Number] = None,
    deleteOnTermination: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.EbsDeviceOptionsBase =
    (new software.amazon.awscdk.services.ec2.EbsDeviceOptionsBase.Builder)
      .volumeType(volumeType.orNull)
      .iops(iops.orNull)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .build()
}
