package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ClientVpnRouteOptions {

  def apply(
    target: software.amazon.awscdk.services.ec2.ClientVpnRouteTarget,
    cidr: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.ec2.ClientVpnRouteOptions =
    (new software.amazon.awscdk.services.ec2.ClientVpnRouteOptions.Builder)
      .target(target)
      .cidr(cidr)
      .description(description.orNull)
      .build()
}
