package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ClientVpnEndpointAttributes {

  def apply(
    securityGroups: List[_ <: software.amazon.awscdk.services.ec2.ISecurityGroup],
    endpointId: String
  ): software.amazon.awscdk.services.ec2.ClientVpnEndpointAttributes =
    (new software.amazon.awscdk.services.ec2.ClientVpnEndpointAttributes.Builder)
      .securityGroups(securityGroups.asJava)
      .endpointId(endpointId)
      .build()
}
