package io.burkard.cdk.services.dynamodb.cfnGlobalTable

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TargetTrackingScalingPolicyConfigurationProperty {

  def apply(
    targetValue: Number,
    scaleInCooldown: Option[Number] = None,
    scaleOutCooldown: Option[Number] = None,
    disableScaleIn: Option[Boolean] = None
  ): software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty =
    (new software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TargetTrackingScalingPolicyConfigurationProperty.Builder)
      .targetValue(targetValue)
      .scaleInCooldown(scaleInCooldown.orNull)
      .scaleOutCooldown(scaleOutCooldown.orNull)
      .disableScaleIn(disableScaleIn.map(Boolean.box).orNull)
      .build()
}
