package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReportGroupProps {

  def apply(
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    reportGroupName: Option[String] = None,
    zipExport: Option[Boolean] = None,
    exportBucket: Option[software.amazon.awscdk.services.s3.IBucket] = None
  ): software.amazon.awscdk.services.codebuild.ReportGroupProps =
    (new software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder)
      .removalPolicy(removalPolicy.orNull)
      .reportGroupName(reportGroupName.orNull)
      .zipExport(zipExport.map(Boolean.box).orNull)
      .exportBucket(exportBucket.orNull)
      .build()
}
