package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReportGroup {

  def apply(
    internalResourceId: String,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    reportGroupName: Option[String] = None,
    zipExport: Option[Boolean] = None,
    exportBucket: Option[software.amazon.awscdk.services.s3.IBucket] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.codebuild.ReportGroup =
    software.amazon.awscdk.services.codebuild.ReportGroup.Builder
      .create(stackCtx, internalResourceId)
      .removalPolicy(removalPolicy.orNull)
      .reportGroupName(reportGroupName.orNull)
      .zipExport(zipExport.map(Boolean.box).orNull)
      .exportBucket(exportBucket.orNull)
      .build()
}
