package io.burkard.cdk.services.codebuild

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object GitHubEnterpriseSourceProps {

  def apply(
    httpsCloneUrl: String,
    reportBuildStatus: Option[Boolean] = None,
    identifier: Option[String] = None,
    webhookFilters: Option[List[_ <: software.amazon.awscdk.services.codebuild.FilterGroup]] = None,
    branchOrRef: Option[String] = None,
    ignoreSslErrors: Option[Boolean] = None,
    cloneDepth: Option[Number] = None,
    webhookTriggersBatchBuild: Option[Boolean] = None,
    webhook: Option[Boolean] = None,
    fetchSubmodules: Option[Boolean] = None
  ): software.amazon.awscdk.services.codebuild.GitHubEnterpriseSourceProps =
    (new software.amazon.awscdk.services.codebuild.GitHubEnterpriseSourceProps.Builder)
      .httpsCloneUrl(httpsCloneUrl)
      .reportBuildStatus(reportBuildStatus.map(Boolean.box).orNull)
      .identifier(identifier.orNull)
      .webhookFilters(webhookFilters.map(_.asJava).orNull)
      .branchOrRef(branchOrRef.orNull)
      .ignoreSslErrors(ignoreSslErrors.map(Boolean.box).orNull)
      .cloneDepth(cloneDepth.orNull)
      .webhookTriggersBatchBuild(webhookTriggersBatchBuild.map(Boolean.box).orNull)
      .webhook(webhook.map(Boolean.box).orNull)
      .fetchSubmodules(fetchSubmodules.map(Boolean.box).orNull)
      .build()
}
