package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestValidator {

  def apply(
    internalResourceId: String,
    restApi: software.amazon.awscdk.services.apigateway.IRestApi,
    validateRequestBody: Option[Boolean] = None,
    validateRequestParameters: Option[Boolean] = None,
    requestValidatorName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.apigateway.RequestValidator =
    software.amazon.awscdk.services.apigateway.RequestValidator.Builder
      .create(stackCtx, internalResourceId)
      .restApi(restApi)
      .validateRequestBody(validateRequestBody.map(Boolean.box).orNull)
      .validateRequestParameters(validateRequestParameters.map(Boolean.box).orNull)
      .requestValidatorName(requestValidatorName.orNull)
      .build()
}
