package io.burkard.cdk.cloudformation.include

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnIncludeProps {

  def apply(
    templateFile: String,
    parameters: Option[Map[String, _]] = None,
    loadNestedStacks: Option[Map[String, _ <: software.amazon.awscdk.cloudformation.include.CfnIncludeProps]] = None,
    preserveLogicalIds: Option[Boolean] = None
  ): software.amazon.awscdk.cloudformation.include.CfnIncludeProps =
    (new software.amazon.awscdk.cloudformation.include.CfnIncludeProps.Builder)
      .templateFile(templateFile)
      .parameters(parameters.map(_.asJava).orNull)
      .loadNestedStacks(loadNestedStacks.map(_.asJava).orNull)
      .preserveLogicalIds(preserveLogicalIds.map(Boolean.box).orNull)
      .build()
}
