package io.burkard.cdk.services.stepfunctions.tasks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResultConfiguration {

  def apply(
    outputLocation: Option[software.amazon.awscdk.services.s3.Location] = None,
    encryptionConfiguration: Option[software.amazon.awscdk.services.stepfunctions.tasks.EncryptionConfiguration] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration =
    (new software.amazon.awscdk.services.stepfunctions.tasks.ResultConfiguration.Builder)
      .outputLocation(outputLocation.orNull)
      .encryptionConfiguration(encryptionConfiguration.orNull)
      .build()
}
