package io.burkard.cdk.services.secretsmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnResourcePolicyProps {

  def apply(
    resourcePolicy: AnyRef,
    secretId: String,
    blockPublicPolicy: Option[Boolean] = None
  ): software.amazon.awscdk.services.secretsmanager.CfnResourcePolicyProps =
    (new software.amazon.awscdk.services.secretsmanager.CfnResourcePolicyProps.Builder)
      .resourcePolicy(resourcePolicy)
      .secretId(secretId)
      .blockPublicPolicy(blockPublicPolicy.map(Boolean.box).orNull)
      .build()
}
