package io.burkard.cdk.services.rds

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnGlobalClusterProps {

  def apply(
    sourceDbClusterIdentifier: Option[String] = None,
    storageEncrypted: Option[Boolean] = None,
    globalClusterIdentifier: Option[String] = None,
    deletionProtection: Option[Boolean] = None,
    engineVersion: Option[String] = None,
    engine: Option[String] = None
  ): software.amazon.awscdk.services.rds.CfnGlobalClusterProps =
    (new software.amazon.awscdk.services.rds.CfnGlobalClusterProps.Builder)
      .sourceDbClusterIdentifier(sourceDbClusterIdentifier.orNull)
      .storageEncrypted(storageEncrypted.map(Boolean.box).orNull)
      .globalClusterIdentifier(globalClusterIdentifier.orNull)
      .deletionProtection(deletionProtection.map(Boolean.box).orNull)
      .engineVersion(engineVersion.orNull)
      .engine(engine.orNull)
      .build()
}
