package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEmailChannel {

  def apply(
    internalResourceId: String,
    applicationId: String,
    fromAddress: String,
    identity: String,
    enabled: Option[Boolean] = None,
    configurationSet: Option[String] = None,
    roleArn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnEmailChannel =
    software.amazon.awscdk.services.pinpoint.CfnEmailChannel.Builder
      .create(stackCtx, internalResourceId)
      .applicationId(applicationId)
      .fromAddress(fromAddress)
      .identity(identity)
      .enabled(enabled.map(Boolean.box).orNull)
      .configurationSet(configurationSet.orNull)
      .roleArn(roleArn.orNull)
      .build()
}
