package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSubscriptionFilterProps {

  def apply(
    logGroupName: String,
    destinationArn: String,
    filterPattern: String,
    roleArn: Option[String] = None
  ): software.amazon.awscdk.services.logs.CfnSubscriptionFilterProps =
    (new software.amazon.awscdk.services.logs.CfnSubscriptionFilterProps.Builder)
      .logGroupName(logGroupName)
      .destinationArn(destinationArn)
      .filterPattern(filterPattern)
      .roleArn(roleArn.orNull)
      .build()
}
