package io.burkard.cdk.services.lambda

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AssetImageCode {

  def apply(
    directory: String,
    buildArgs: Option[Map[String, String]] = None,
    invalidation: Option[software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions] = None,
    cmd: Option[List[String]] = None,
    entrypoint: Option[List[String]] = None,
    extraHash: Option[String] = None,
    workingDirectory: Option[String] = None,
    followSymlinks: Option[software.amazon.awscdk.SymlinkFollowMode] = None,
    file: Option[String] = None,
    networkMode: Option[software.amazon.awscdk.services.ecr.assets.NetworkMode] = None,
    target: Option[String] = None,
    exclude: Option[List[String]] = None,
    ignoreMode: Option[software.amazon.awscdk.IgnoreMode] = None
  ): software.amazon.awscdk.services.lambda.AssetImageCode =
    software.amazon.awscdk.services.lambda.AssetImageCode.Builder
      .create(directory)
      .buildArgs(buildArgs.map(_.asJava).orNull)
      .invalidation(invalidation.orNull)
      .cmd(cmd.map(_.asJava).orNull)
      .entrypoint(entrypoint.map(_.asJava).orNull)
      .extraHash(extraHash.orNull)
      .workingDirectory(workingDirectory.orNull)
      .followSymlinks(followSymlinks.orNull)
      .file(file.orNull)
      .networkMode(networkMode.orNull)
      .target(target.orNull)
      .exclude(exclude.map(_.asJava).orNull)
      .ignoreMode(ignoreMode.orNull)
      .build()
}
