package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SubnetProps {

  def apply(
    availabilityZone: String,
    vpcId: String,
    cidrBlock: String,
    mapPublicIpOnLaunch: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.SubnetProps =
    (new software.amazon.awscdk.services.ec2.SubnetProps.Builder)
      .availabilityZone(availabilityZone)
      .vpcId(vpcId)
      .cidrBlock(cidrBlock)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).orNull)
      .build()
}
