package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEIPProps {

  def apply(
    domain: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    instanceId: Option[String] = None,
    publicIpv4Pool: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnEIPProps =
    (new software.amazon.awscdk.services.ec2.CfnEIPProps.Builder)
      .domain(domain.orNull)
      .tags(tags.map(_.asJava).orNull)
      .instanceId(instanceId.orNull)
      .publicIpv4Pool(publicIpv4Pool.orNull)
      .build()
}
