package io.burkard.cdk.services.docdb

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDBInstance {

  def apply(
    internalResourceId: String,
    dbInstanceClass: String,
    dbClusterIdentifier: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    availabilityZone: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    autoMinorVersionUpgrade: Option[Boolean] = None,
    dbInstanceIdentifier: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.docdb.CfnDBInstance =
    software.amazon.awscdk.services.docdb.CfnDBInstance.Builder
      .create(stackCtx, internalResourceId)
      .dbInstanceClass(dbInstanceClass)
      .dbClusterIdentifier(dbClusterIdentifier)
      .tags(tags.map(_.asJava).orNull)
      .availabilityZone(availabilityZone.orNull)
      .preferredMaintenanceWindow(preferredMaintenanceWindow.orNull)
      .autoMinorVersionUpgrade(autoMinorVersionUpgrade.map(Boolean.box).orNull)
      .dbInstanceIdentifier(dbInstanceIdentifier.orNull)
      .build()
}
