package io.burkard.cdk.services.directoryservice

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSimpleADProps {

  def apply(
    name: String,
    size: String,
    vpcSettings: software.amazon.awscdk.services.directoryservice.CfnSimpleAD.VpcSettingsProperty,
    password: String,
    description: Option[String] = None,
    createAlias: Option[Boolean] = None,
    enableSso: Option[Boolean] = None,
    shortName: Option[String] = None
  ): software.amazon.awscdk.services.directoryservice.CfnSimpleADProps =
    (new software.amazon.awscdk.services.directoryservice.CfnSimpleADProps.Builder)
      .name(name)
      .size(size)
      .vpcSettings(vpcSettings)
      .password(password)
      .description(description.orNull)
      .createAlias(createAlias.map(Boolean.box).orNull)
      .enableSso(enableSso.map(Boolean.box).orNull)
      .shortName(shortName.orNull)
      .build()
}
