package io.burkard.cdk.services.codestarconnections

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConnectionProps {

  def apply(
    connectionName: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    providerType: Option[String] = None,
    hostArn: Option[String] = None
  ): software.amazon.awscdk.services.codestarconnections.CfnConnectionProps =
    (new software.amazon.awscdk.services.codestarconnections.CfnConnectionProps.Builder)
      .connectionName(connectionName)
      .tags(tags.map(_.asJava).orNull)
      .providerType(providerType.orNull)
      .hostArn(hostArn.orNull)
      .build()
}
