package io.burkard.cdk.services.apprunner.cfnService

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SourceConfigurationProperty {

  def apply(
    authenticationConfiguration: Option[software.amazon.awscdk.services.apprunner.CfnService.AuthenticationConfigurationProperty] = None,
    autoDeploymentsEnabled: Option[Boolean] = None,
    codeRepository: Option[software.amazon.awscdk.services.apprunner.CfnService.CodeRepositoryProperty] = None,
    imageRepository: Option[software.amazon.awscdk.services.apprunner.CfnService.ImageRepositoryProperty] = None
  ): software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty =
    (new software.amazon.awscdk.services.apprunner.CfnService.SourceConfigurationProperty.Builder)
      .authenticationConfiguration(authenticationConfiguration.orNull)
      .autoDeploymentsEnabled(autoDeploymentsEnabled.map(Boolean.box).orNull)
      .codeRepository(codeRepository.orNull)
      .imageRepository(imageRepository.orNull)
      .build()
}
