package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AssetOptions {

  def apply(
    assetHash: Option[String] = None,
    assetHashType: Option[software.amazon.awscdk.AssetHashType] = None,
    bundling: Option[software.amazon.awscdk.BundlingOptions] = None
  ): software.amazon.awscdk.AssetOptions =
    (new software.amazon.awscdk.AssetOptions.Builder)
      .assetHash(assetHash.orNull)
      .assetHashType(assetHashType.orNull)
      .bundling(bundling.orNull)
      .build()
}
