package io.burkard.cdk.services.stepfunctions.tasks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SageMakerCreateModelProps {

  def apply(
    modelName: String,
    primaryContainer: software.amazon.awscdk.services.stepfunctions.tasks.IContainerDefinition,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    tags: Option[software.amazon.awscdk.services.stepfunctions.TaskInput] = None,
    enableNetworkIsolation: Option[Boolean] = None,
    resultPath: Option[String] = None,
    subnetSelection: Option[software.amazon.awscdk.services.ec2.SubnetSelection] = None,
    containers: Option[List[_ <: software.amazon.awscdk.services.stepfunctions.tasks.IContainerDefinition]] = None,
    integrationPattern: Option[software.amazon.awscdk.services.stepfunctions.IntegrationPattern] = None,
    outputPath: Option[String] = None,
    comment: Option[String] = None,
    resultSelector: Option[Map[String, _]] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    inputPath: Option[String] = None,
    timeout: Option[software.amazon.awscdk.Duration] = None,
    heartbeat: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModelProps =
    (new software.amazon.awscdk.services.stepfunctions.tasks.SageMakerCreateModelProps.Builder)
      .modelName(modelName)
      .primaryContainer(primaryContainer)
      .role(role.orNull)
      .tags(tags.orNull)
      .enableNetworkIsolation(enableNetworkIsolation.map(Boolean.box).orNull)
      .resultPath(resultPath.orNull)
      .subnetSelection(subnetSelection.orNull)
      .containers(containers.map(_.asJava).orNull)
      .integrationPattern(integrationPattern.orNull)
      .outputPath(outputPath.orNull)
      .comment(comment.orNull)
      .resultSelector(resultSelector.map(_.asJava).orNull)
      .vpc(vpc.orNull)
      .inputPath(inputPath.orNull)
      .timeout(timeout.orNull)
      .heartbeat(heartbeat.orNull)
      .build()
}
