package io.burkard.cdk.services.route53recoverycontrol

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSafetyRule {

  def apply(
    internalResourceId: String,
    name: String,
    ruleConfig: software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.RuleConfigProperty,
    controlPanelArn: String,
    gatingRule: Option[software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.GatingRuleProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    assertionRule: Option[software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.AssertionRuleProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule =
    software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .ruleConfig(ruleConfig)
      .controlPanelArn(controlPanelArn)
      .gatingRule(gatingRule.orNull)
      .tags(tags.map(_.asJava).orNull)
      .assertionRule(assertionRule.orNull)
      .build()
}
