package io.burkard.cdk.services.rds

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnGlobalCluster {

  def apply(
    internalResourceId: String,
    sourceDbClusterIdentifier: Option[String] = None,
    storageEncrypted: Option[Boolean] = None,
    globalClusterIdentifier: Option[String] = None,
    deletionProtection: Option[Boolean] = None,
    engineVersion: Option[String] = None,
    engine: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.rds.CfnGlobalCluster =
    software.amazon.awscdk.services.rds.CfnGlobalCluster.Builder
      .create(stackCtx, internalResourceId)
      .sourceDbClusterIdentifier(sourceDbClusterIdentifier.orNull)
      .storageEncrypted(storageEncrypted.map(Boolean.box).orNull)
      .globalClusterIdentifier(globalClusterIdentifier.orNull)
      .deletionProtection(deletionProtection.map(Boolean.box).orNull)
      .engineVersion(engineVersion.orNull)
      .engine(engine.orNull)
      .build()
}
