package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCertificateProps {

  def apply(
    certificateName: String,
    domainName: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    subjectAlternativeNames: Option[List[String]] = None
  ): software.amazon.awscdk.services.lightsail.CfnCertificateProps =
    (new software.amazon.awscdk.services.lightsail.CfnCertificateProps.Builder)
      .certificateName(certificateName)
      .domainName(domainName)
      .tags(tags.map(_.asJava).orNull)
      .subjectAlternativeNames(subjectAlternativeNames.map(_.asJava).orNull)
      .build()
}
