package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAlarmProps {

  def apply(
    metricName: String,
    monitoredResourceName: String,
    comparisonOperator: String,
    threshold: Number,
    evaluationPeriods: Number,
    alarmName: String,
    notificationEnabled: Option[Boolean] = None,
    datapointsToAlarm: Option[Number] = None,
    contactProtocols: Option[List[String]] = None,
    treatMissingData: Option[String] = None,
    notificationTriggers: Option[List[String]] = None
  ): software.amazon.awscdk.services.lightsail.CfnAlarmProps =
    (new software.amazon.awscdk.services.lightsail.CfnAlarmProps.Builder)
      .metricName(metricName)
      .monitoredResourceName(monitoredResourceName)
      .comparisonOperator(comparisonOperator)
      .threshold(threshold)
      .evaluationPeriods(evaluationPeriods)
      .alarmName(alarmName)
      .notificationEnabled(notificationEnabled.map(Boolean.box).orNull)
      .datapointsToAlarm(datapointsToAlarm.orNull)
      .contactProtocols(contactProtocols.map(_.asJava).orNull)
      .treatMissingData(treatMissingData.orNull)
      .notificationTriggers(notificationTriggers.map(_.asJava).orNull)
      .build()
}
