package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Runtime {

  def apply(
    name: String,
    family: software.amazon.awscdk.services.lambda.RuntimeFamily,
    bundlingDockerImage: Option[String] = None,
    supportsCodeGuruProfiling: Option[Boolean] = None,
    supportsInlineCode: Option[Boolean] = None
  ): software.amazon.awscdk.services.lambda.Runtime =
    software.amazon.awscdk.services.lambda.Runtime.Builder
      .create(name, family)
      .bundlingDockerImage(bundlingDockerImage.orNull)
      .supportsCodeGuruProfiling(supportsCodeGuruProfiling.map(Boolean.box).orNull)
      .supportsInlineCode(supportsInlineCode.map(Boolean.box).orNull)
      .build()
}
