package io.burkard.cdk.services.kinesisanalyticsv2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplication {

  def apply(
    internalResourceId: String,
    serviceExecutionRole: String,
    runtimeEnvironment: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    applicationName: Option[String] = None,
    applicationConfiguration: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationConfigurationProperty] = None,
    applicationMode: Option[String] = None,
    applicationDescription: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication =
    software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.Builder
      .create(stackCtx, internalResourceId)
      .serviceExecutionRole(serviceExecutionRole)
      .runtimeEnvironment(runtimeEnvironment)
      .tags(tags.map(_.asJava).orNull)
      .applicationName(applicationName.orNull)
      .applicationConfiguration(applicationConfiguration.orNull)
      .applicationMode(applicationMode.orNull)
      .applicationDescription(applicationDescription.orNull)
      .build()
}
