package io.burkard.cdk.services.events.cfnRule

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RedshiftDataParametersProperty {

  def apply(
    database: String,
    sql: String,
    dbUser: Option[String] = None,
    secretManagerArn: Option[String] = None,
    statementName: Option[String] = None,
    withEvent: Option[Boolean] = None
  ): software.amazon.awscdk.services.events.CfnRule.RedshiftDataParametersProperty =
    (new software.amazon.awscdk.services.events.CfnRule.RedshiftDataParametersProperty.Builder)
      .database(database)
      .sql(sql)
      .dbUser(dbUser.orNull)
      .secretManagerArn(secretManagerArn.orNull)
      .statementName(statementName.orNull)
      .withEvent(withEvent.map(Boolean.box).orNull)
      .build()
}
