package io.burkard.cdk.services.events

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConnectionProps {

  def apply(
    authorizationType: String,
    authParameters: AnyRef,
    name: Option[String] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.events.CfnConnectionProps =
    (new software.amazon.awscdk.services.events.CfnConnectionProps.Builder)
      .authorizationType(authorizationType)
      .authParameters(authParameters)
      .name(name.orNull)
      .description(description.orNull)
      .build()
}
