package io.burkard.cdk.services.elasticloadbalancingv2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ApplicationListenerAttributes {

  def apply(
    listenerArn: String,
    defaultPort: Option[Number] = None,
    securityGroup: Option[software.amazon.awscdk.services.ec2.ISecurityGroup] = None
  ): software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerAttributes =
    (new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerAttributes.Builder)
      .listenerArn(listenerArn)
      .defaultPort(defaultPort.orNull)
      .securityGroup(securityGroup.orNull)
      .build()
}
