package io.burkard.cdk.services.efs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AccessPointOptions {

  def apply(
    path: Option[String] = None,
    createAcl: Option[software.amazon.awscdk.services.efs.Acl] = None,
    posixUser: Option[software.amazon.awscdk.services.efs.PosixUser] = None
  ): software.amazon.awscdk.services.efs.AccessPointOptions =
    (new software.amazon.awscdk.services.efs.AccessPointOptions.Builder)
      .path(path.orNull)
      .createAcl(createAcl.orNull)
      .posixUser(posixUser.orNull)
      .build()
}
