package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VpnConnectionOptions {

  def apply(
    ip: String,
    asn: Option[Number] = None,
    tunnelOptions: Option[List[_ <: software.amazon.awscdk.services.ec2.VpnTunnelOption]] = None,
    staticRoutes: Option[List[String]] = None
  ): software.amazon.awscdk.services.ec2.VpnConnectionOptions =
    (new software.amazon.awscdk.services.ec2.VpnConnectionOptions.Builder)
      .ip(ip)
      .asn(asn.orNull)
      .tunnelOptions(tunnelOptions.map(_.asJava).orNull)
      .staticRoutes(staticRoutes.map(_.asJava).orNull)
      .build()
}
