package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SubnetNetworkAclAssociationProps {

  def apply(
    subnet: software.amazon.awscdk.services.ec2.ISubnet,
    networkAcl: software.amazon.awscdk.services.ec2.INetworkAcl,
    subnetNetworkAclAssociationName: Option[String] = None
  ): software.amazon.awscdk.services.ec2.SubnetNetworkAclAssociationProps =
    (new software.amazon.awscdk.services.ec2.SubnetNetworkAclAssociationProps.Builder)
      .subnet(subnet)
      .networkAcl(networkAcl)
      .subnetNetworkAclAssociationName(subnetNetworkAclAssociationName.orNull)
      .build()
}
