package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PublicSubnet {

  def apply(
    internalResourceId: String,
    availabilityZone: Option[String] = None,
    vpcId: Option[String] = None,
    cidrBlock: Option[String] = None,
    mapPublicIpOnLaunch: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.PublicSubnet =
    software.amazon.awscdk.services.ec2.PublicSubnet.Builder
      .create(stackCtx, internalResourceId)
      .availabilityZone(availabilityZone.orNull)
      .vpcId(vpcId.orNull)
      .cidrBlock(cidrBlock.orNull)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).orNull)
      .build()
}
