package io.burkard.cdk.services.docdb

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDBCluster {

  def apply(
    internalResourceId: String,
    masterUserPassword: String,
    masterUsername: String,
    snapshotIdentifier: Option[String] = None,
    storageEncrypted: Option[Boolean] = None,
    dbClusterIdentifier: Option[String] = None,
    vpcSecurityGroupIds: Option[List[String]] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    preferredMaintenanceWindow: Option[String] = None,
    deletionProtection: Option[Boolean] = None,
    port: Option[Number] = None,
    backupRetentionPeriod: Option[Number] = None,
    dbSubnetGroupName: Option[String] = None,
    dbClusterParameterGroupName: Option[String] = None,
    kmsKeyId: Option[String] = None,
    enableCloudwatchLogsExports: Option[List[String]] = None,
    preferredBackupWindow: Option[String] = None,
    availabilityZones: Option[List[String]] = None,
    engineVersion: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.docdb.CfnDBCluster =
    software.amazon.awscdk.services.docdb.CfnDBCluster.Builder
      .create(stackCtx, internalResourceId)
      .masterUserPassword(masterUserPassword)
      .masterUsername(masterUsername)
      .snapshotIdentifier(snapshotIdentifier.orNull)
      .storageEncrypted(storageEncrypted.map(Boolean.box).orNull)
      .dbClusterIdentifier(dbClusterIdentifier.orNull)
      .vpcSecurityGroupIds(vpcSecurityGroupIds.map(_.asJava).orNull)
      .tags(tags.map(_.asJava).orNull)
      .preferredMaintenanceWindow(preferredMaintenanceWindow.orNull)
      .deletionProtection(deletionProtection.map(Boolean.box).orNull)
      .port(port.orNull)
      .backupRetentionPeriod(backupRetentionPeriod.orNull)
      .dbSubnetGroupName(dbSubnetGroupName.orNull)
      .dbClusterParameterGroupName(dbClusterParameterGroupName.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .enableCloudwatchLogsExports(enableCloudwatchLogsExports.map(_.asJava).orNull)
      .preferredBackupWindow(preferredBackupWindow.orNull)
      .availabilityZones(availabilityZones.map(_.asJava).orNull)
      .engineVersion(engineVersion.orNull)
      .build()
}
