package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ErrorResponse {

  def apply(
    httpStatus: Number,
    ttl: Option[software.amazon.awscdk.Duration] = None,
    responseHttpStatus: Option[Number] = None,
    responsePagePath: Option[String] = None
  ): software.amazon.awscdk.services.cloudfront.ErrorResponse =
    (new software.amazon.awscdk.services.cloudfront.ErrorResponse.Builder)
      .httpStatus(httpStatus)
      .ttl(ttl.orNull)
      .responseHttpStatus(responseHttpStatus.orNull)
      .responsePagePath(responsePagePath.orNull)
      .build()
}
