package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestContext {

  def apply(
    resourcePath: Option[Boolean] = None,
    resourceId: Option[Boolean] = None,
    stage: Option[Boolean] = None,
    cognitoIdentityPoolId: Option[Boolean] = None,
    cognitoIdentityId: Option[Boolean] = None,
    httpMethod: Option[Boolean] = None,
    accountId: Option[Boolean] = None,
    userAgent: Option[Boolean] = None,
    apiKey: Option[Boolean] = None,
    authorizerPrincipalId: Option[Boolean] = None,
    apiId: Option[Boolean] = None,
    requestId: Option[Boolean] = None,
    userArn: Option[Boolean] = None,
    sourceIp: Option[Boolean] = None,
    user: Option[Boolean] = None,
    cognitoAuthenticationType: Option[Boolean] = None,
    cognitoAuthenticationProvider: Option[Boolean] = None,
    caller: Option[Boolean] = None
  ): software.amazon.awscdk.services.apigateway.RequestContext =
    (new software.amazon.awscdk.services.apigateway.RequestContext.Builder)
      .resourcePath(resourcePath.map(Boolean.box).orNull)
      .resourceId(resourceId.map(Boolean.box).orNull)
      .stage(stage.map(Boolean.box).orNull)
      .cognitoIdentityPoolId(cognitoIdentityPoolId.map(Boolean.box).orNull)
      .cognitoIdentityId(cognitoIdentityId.map(Boolean.box).orNull)
      .httpMethod(httpMethod.map(Boolean.box).orNull)
      .accountId(accountId.map(Boolean.box).orNull)
      .userAgent(userAgent.map(Boolean.box).orNull)
      .apiKey(apiKey.map(Boolean.box).orNull)
      .authorizerPrincipalId(authorizerPrincipalId.map(Boolean.box).orNull)
      .apiId(apiId.map(Boolean.box).orNull)
      .requestId(requestId.map(Boolean.box).orNull)
      .userArn(userArn.map(Boolean.box).orNull)
      .sourceIp(sourceIp.map(Boolean.box).orNull)
      .user(user.map(Boolean.box).orNull)
      .cognitoAuthenticationType(cognitoAuthenticationType.map(Boolean.box).orNull)
      .cognitoAuthenticationProvider(cognitoAuthenticationProvider.map(Boolean.box).orNull)
      .caller(caller.map(Boolean.box).orNull)
      .build()
}
